
#ifndef __SOLITON_PcitgLIB_h__
#define __SOLITON_PcitgLIB_h__
// The following ifdef block is the standard way of creating macros which make exporting 
// from a DLL simpler. All files within this DLL are compiled with the PCITGLIB_EXPORTS
// symbol defined on the command line. this symbol should not be defined on any project
// that uses this DLL. This way any other project whose source files include this file see 
// PCITGLIB_API functions as being imported from a DLL, wheras this DLL sees symbols
// defined with this macro as being exported.


#ifdef PCITGLIB_EXPORTS
#define PCITGLIB_API __declspec(dllexport)
#else
#define PCITGLIB_API __declspec(dllimport)
#endif


#define PCITG_PORT_CTL 0x01
#define PCITG_PORT_A 0x02
#define PCITG_PORT_B 0x04
#define PCITG_PORT_C 0x08
#define PCITG_PORT_ALL 0x0F
//#define PCITG_PORT_MBOX 0x10

#define PCITG_CHIP0 0
#define PCITG_CHIP1 1
#define PCITG_MBOX 2

//#define PCITC_INTCTL 0x20
#define PCITG_IRQ_EXT		0
#define PCITG_IRQ_B0		1
#define PCITG_IRQ_A0		2
#define PCITG_IRQ_B1		4
#define PCITG_IRQ_A1		8

// return ststus
#define PCITG_ERROR 1
#define PCITG_OK 0
#define PCITG_NULL INVALID_HANDLE_VALUE



typedef struct  _pcitg_t {
	HANDLE hDevice; 
	unsigned char ctl[2];
	HANDLE IsrThread;
	HANDLE IsrEventHandle;	
	PVOID pExt;
	void (*handler)(struct _pcitg_t* board, int intvec);      // UserISR prototype
} *pcitg_t;

#ifdef __cplusplus
extern "C" {
#endif


PCITGLIB_API DWORD __stdcall WINAPI SysISRThread(pcitg_t board);
PCITGLIB_API pcitg_t __stdcall pcitg_open(DWORD instance);
PCITGLIB_API void  __stdcall pcitg_close(pcitg_t board);
PCITGLIB_API int __stdcall pcitg_in(pcitg_t board, int chip, int port, unsigned long *value);
PCITGLIB_API int __stdcall pcitg_out(pcitg_t board, int chip, int port, unsigned long value);
PCITGLIB_API int __stdcall  pcitg_in2(pcitg_t board, int ports, unsigned long *value);
PCITGLIB_API int __stdcall  pcitg_out2(pcitg_t board, int ports, unsigned long value);
PCITGLIB_API int __stdcall  pcitg_setupevent(pcitg_t board);
PCITGLIB_API int __stdcall  pcitg_deleteevent(pcitg_t board);
PCITGLIB_API int __stdcall  pcitg_mbin(pcitg_t board, unsigned long *value);
PCITGLIB_API int  __stdcall pcitg_mbout(pcitg_t board, unsigned long value);
PCITGLIB_API int __stdcall  pcitg_intcin(pcitg_t board, unsigned long *value);
PCITGLIB_API int __stdcall  pcitg_intcout(pcitg_t board, unsigned long value);
PCITGLIB_API int __stdcall  pcitg_get_vector(pcitg_t board);
PCITGLIB_API int  __stdcall pcitg_connect(pcitg_t board, void (*sig_handler) (pcitg_t, int));
PCITGLIB_API int  __stdcall  pcitg_set_extension(pcitg_t board, PVOID pext);
PCITGLIB_API PVOID  __stdcall  pcitg_get_extension(pcitg_t board);



#ifdef __cplusplus
}
#endif

#endif